require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'
require 'watir-scroll'

describe '[VaRut-402 Adding VA Tool Set to Lunchpad]' do
  include DriverUtility

  before(:all) do
    initializeConfigurations(LAUNCHPAD_URL)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-655|TC#VARUT-652 : VA Tool Set displayed' do

    it "Verifying the text" do
      @vts_po.common.wait_untill_elements_size_steadied

      va_tool_set_link = @driver.a(:css=> "a[href='/va-tool-set']")
      va_tool_set_link.scroll.to :top

      expect(@vts_po.launchpad.vaToolSet_head_element.text).to eq("VA Tool Set")
      expect(@vts_po.launchpad.vaToolSet_desc_element.text).to eq("Access to VA Mobile app configuration and management tools")
    end
  end
end







